/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

// Modified slightly to avoid production of nans. TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse AUTO_MOUSE

/////////////////////////////////////////////////////////////////////////////////

// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.

#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
#define MOUSE_POS   vec2((1.0+cos(iGlobalTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )

/////////////////////////////////////////////////////////////////////////////////

// Created by randy read - rcread/2015
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

// a variant of sechristo's very cool https://www.shadertoy.com/view/MljXW1

//shoutout to iq for the getNormal function

#define EPS 0.01
#define TAU 2.0*3.14159265359


float map (float r, float angle) {
   return (tan(angle*3.0+iGlobalTime*0.1)*0.5)+0.5 + sin(r*30.0)*0.1;
}

vec3 getNormal(float r, float angle) {
    vec3 n = vec3( map(r-EPS,angle) - map(r+EPS,angle),map(r,angle-EPS) - map(r,angle+EPS),5.0*EPS);
    return normalize( n );
}

float map1(float x, float y) {
    vec2 uv = vec2(x,y);
    float r = length(uv);
    float angle = atan(uv.y,uv.x);

    vec3 light = normalize(vec3(sin(1.0),cos(1.0),sin(iGlobalTime*0.1)));
    return pow(abs(dot(light,getNormal(r,angle))),2.0);
}

float map1(float x, float y, float offset) {
    vec2 uv = vec2(x,y);
    float r = length(uv);
    float angle = atan(uv.y,uv.x);

    vec3 light = normalize(vec3(sin(1.0),cos(1.0),sin(iGlobalTime*0.1)));
    return pow(abs(dot(light,getNormal(r,angle+offset))),2.0);
}

vec3 getXYNormal(float x, float y) {
        vec3 n = vec3( map1(x-EPS,y) - map1(x+EPS,y),map1(x,y-EPS) - map1(x,y+EPS),150.0*EPS);
    return normalize( n );
}



void main ( void )
{
    vec2 uv = gl_FragCoord.xy / iResolution.xy;
    vec2 mouse = iMouse.xy / iResolution.xy;

    float c = 0.5;

    uv.x -= 0.5;
    uv.y -= 0.5;
    mouse.x -= 0.5;
    mouse.y -= 0.5;

    uv.y *= iResolution.y/iResolution.x;
    mouse.y *= iResolution.y/iResolution.x;

    float ch = 50.0;
    float cr = sin(map1(uv.x,uv.y,0.0)*sin(map1(uv.x,uv.y,0.0)));
    float cg = sin(map1(uv.x,uv.y,1.0*ch)*sin(map1(uv.x,uv.y,1.0*ch)));
    float cb = sin(map1(uv.x,uv.y,2.0*ch)*sin(map1(uv.x,uv.y,2.0*ch)));
    cr = map1(cr,cg);
    cg = map1(cg,cb);
    cb = map1(cr,cb);
    vec3 tint = vec3(0.2,0.1,0.3);
    float w = 6. * sin( iGlobalTime * 7. / 11. );
    vec3 col = vec3( cr,cg,cb) + tint;
    col = ( w * normalize( col ) + -w * col / max(cr,max(cg,cb) ) ) / 2.;

    vec3 mLoc = vec3(sin(-iGlobalTime)*0.333,cos(-iGlobalTime)*0.333,-2.0);
    vec3 light = vec3(uv.x,uv.y,map1(uv.x,uv.y))-mLoc;
    vec3 lDir = normalize(light);
    vec3 normal = getXYNormal(map1(uv.x,uv.y),map1(uv.y,uv.x));
    col += pow(abs(dot(lDir,normal)),200.0)*6.0;
    col += pow(abs(dot(lDir,normal)),50.0)*1.0;
    col += tint;
    col *= 0.1;

    gl_FragColor = vec4 ( col, length(col) );

}